/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.constants.EnumQuestTask;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.quests.QuestObjective;

public class QuestData {
    public final NBTTagCompound extraData = new NBTTagCompound();
    public boolean isCompleted = false;
    public Quest quest;

    public QuestData(Quest quest) {
        this.quest = quest;
        int pos = 0;
        for (QuestObjective task : quest.questInterface.tasks) {
            NBTTagCompound nbt;
            if (task.getEnumType() == EnumQuestTask.KILL || task.getEnumType() == EnumQuestTask.AREAKILL || task.getEnumType() == EnumQuestTask.MANUAL) {
                if (!this.extraData.func_150297_b("Targets", 9)) {
                    this.extraData.func_74782_a("Targets", (NBTBase)new NBTTagList());
                }
                nbt = new NBTTagCompound();
                nbt.func_74778_a("Slot", task.getTargetName());
                nbt.func_74768_a("Value", 0);
                nbt.func_74768_a("ObjectPos", pos);
                this.extraData.func_150295_c("Targets", 10).func_74742_a((NBTBase)nbt);
            } else if (task.getEnumType() == EnumQuestTask.CRAFT) {
                if (task.getItem().isEmpty()) continue;
                if (this.extraData.func_150297_b("Crafts", 9)) {
                    this.extraData.func_74782_a("Crafts", (NBTBase)new NBTTagList());
                }
                nbt = new NBTTagCompound();
                nbt.func_74782_a("Item", (NBTBase)task.getItemStack().func_77955_b(new NBTTagCompound()));
                nbt.func_74768_a("Value", 0);
                nbt.func_74768_a("ObjectPos", pos);
                this.extraData.func_150295_c("Crafts", 10).func_74742_a((NBTBase)nbt);
            } else if (task.getEnumType() == EnumQuestTask.LOCATION) {
                if (this.extraData.func_150297_b("Locations", 9)) {
                    this.extraData.func_74782_a("Locations", (NBTBase)new NBTTagList());
                }
                nbt = new NBTTagCompound();
                nbt.func_74778_a("Location", task.getTargetName());
                nbt.func_74757_a("Found", false);
                nbt.func_74768_a("ObjectPos", pos);
                this.extraData.func_150295_c("Locations", 10).func_74742_a((NBTBase)nbt);
            }
            ++pos;
        }
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        this.isCompleted = nbttagcompound.func_74767_n("QuestCompleted");
        ArrayList list = new ArrayList(this.extraData.func_150296_c());
        for (String key : list) {
            this.extraData.func_82580_o(key);
        }
        list = new ArrayList(nbttagcompound.func_74775_l("ExtraData").func_150296_c());
        for (String key : list) {
            this.extraData.func_74782_a(key, nbttagcompound.func_74775_l("ExtraData").func_74781_a(key));
        }
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74757_a("QuestCompleted", this.isCompleted);
        nbttagcompound.func_74782_a("ExtraData", (NBTBase)this.extraData);
    }
}

